///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1999-2005 Siebel Systems, Inc.  All rights reserved.
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// AggByFilterEditor
///////////////////////////////////////////////////////////////////////////////

//-------------------

function AggByFilterEditor(editorID, sFormula)
{
   this.sFormula = sFormula;
   this.sAggByFormula = null;
}

AggByFilterEditor.prototype = new XUIEditor();

//-------------------
AggByFilterEditor.prototype.load = function(xmlElement)
{
   XUICheckNodeName("AggByFilterEditor.prototype.load", xmlElement, "sawx:expr", "sawx:sqlExpression");
   this.element = xmlElement;
   document.getElementById('idAggByFilterColumnName').innerHTML = this.sFormula;

}

//-------------------
AggByFilterEditor.prototype.apply = function()
{
   // Easiest way of extending the expr schema to handle aggBy are to set them
   // as attributes and have a fixed number of them.
   for (i=0; i < ColumnFilterEditor.MAX_AGGBYS; i++)
   {
      if (XUIGetAttributeString (this.element, "aggBy"+i) == "")
      {
         XUISetOrRemoveAttributeString (this.element, "aggBy"+i, this.sAggByFormula);
         return true;
      }
   }

   return true;
}

//-------------------
AggByFilterEditor.prototype.focus = function()
{
	//this.form.caption.focus();
}

//-------------------
AggByFilterEditor.prototype.applyAggregateBy = function(sFormula)
{
   var tInfo = XUIColumnSpace.findInfo(null, sFormula);

   if (tInfo == null)
   {
      alert ('Unable to apply aggregate by.  No column space for:' + sFormula); //Should not happen
      return;
   }

   if (XUIColumnSpace.getInfoSQLAttr(tInfo, "aggType") == "agg")
   {
      alert (kmsgFilterEditorNonAggByFields);
      return;
   }

   this.sAggByFormula = sFormula;
   XUIDialog.ok('idAggByFilter');
}
